/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ModuleVersionSelectorStrictSpec;
import org.gradle.api.internal.artifacts.capability.DefaultSpecificCapabilitySelector;
import org.gradle.api.internal.artifacts.capability.FeatureCapabilitySelector;
import org.gradle.api.internal.artifacts.capability.SpecificCapabilitySelector;
import org.gradle.api.internal.artifacts.dependencies.AbstractModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.jspecify.annotations.Nullable;

public abstract class AbstractExternalModuleDependency
extends AbstractModuleDependency
implements ExternalModuleDependency {
    private final ModuleIdentifier moduleIdentifier;
    private boolean changing;
    private final MutableVersionConstraint versionConstraint;

    public AbstractExternalModuleDependency(ModuleIdentifier module, String version, @Nullable String configuration) {
        this.moduleIdentifier = module;
        this.versionConstraint = new DefaultMutableVersionConstraint(version);
        if (configuration != null) {
            this.setTargetConfiguration(configuration);
        }
    }

    public AbstractExternalModuleDependency(ModuleIdentifier module, MutableVersionConstraint version, @Nullable String configuration) {
        this.moduleIdentifier = module;
        this.versionConstraint = version;
        if (configuration != null) {
            this.setTargetConfiguration(configuration);
        }
    }

    protected void copyTo(AbstractExternalModuleDependency target) {
        super.copyTo((AbstractModuleDependency)target);
        target.setChanging(this.isChanging());
    }

    public boolean matchesStrictly(ModuleVersionIdentifier identifier) {
        return new ModuleVersionSelectorStrictSpec((ModuleVersionSelector)this).isSatisfiedBy(identifier);
    }

    public @Nullable String getGroup() {
        return this.moduleIdentifier.getGroup();
    }

    public String getName() {
        return this.moduleIdentifier.getName();
    }

    public @Nullable String getVersion() {
        String requiredVersion = this.versionConstraint.getRequiredVersion();
        String version = requiredVersion.isEmpty() ? this.versionConstraint.getPreferredVersion() : requiredVersion;
        return Strings.emptyToNull((String)version);
    }

    public boolean isForce() {
        return false;
    }

    public boolean isChanging() {
        return this.changing;
    }

    public ExternalModuleDependency setChanging(boolean changing) {
        this.validateMutation(this.changing, changing);
        this.changing = changing;
        return this;
    }

    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public void version(Action<? super MutableVersionConstraint> configureAction) {
        this.validateMutation();
        configureAction.execute((Object)this.versionConstraint);
    }

    public ModuleIdentifier getModule() {
        return this.moduleIdentifier;
    }

    static ModuleIdentifier assertModuleId(@Nullable String group, @Nullable String name) {
        if (name == null) {
            throw new InvalidUserDataException("Name must not be null!");
        }
        return DefaultModuleIdentifier.newId(group, name);
    }

    public List<Capability> getRequestedCapabilities() {
        return (List)this.getCapabilitySelectors().stream().map(c -> {
            if (c instanceof SpecificCapabilitySelector) {
                return ((DefaultSpecificCapabilitySelector)c).getBackingCapability();
            }
            if (c instanceof FeatureCapabilitySelector) {
                return new DefaultImmutableCapability(this.getGroup(), this.getName() + "-" + ((FeatureCapabilitySelector)c).getFeatureName(), this.getVersion());
            }
            throw new UnsupportedOperationException("Unsupported capability selector type: " + c.getClass().getName());
        }).collect(ImmutableList.toImmutableList());
    }

    public String toString() {
        return this.getGroup() + ":" + this.getName() + ":" + this.getVersionConstraint().getDisplayName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AbstractExternalModuleDependency that = (AbstractExternalModuleDependency)((Object)o);
        return this.moduleIdentifier.equals(that.moduleIdentifier) && this.versionConstraint.equals(that.versionConstraint) && this.changing == that.changing && this.isCommonContentEquals((ModuleDependency)that);
    }

    public int hashCode() {
        int result = this.getGroup() != null ? this.getGroup().hashCode() : 0;
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + (this.getVersion() != null ? this.getVersion().hashCode() : 0);
        return result;
    }
}

