/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.EndCollection;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.BoundTransformStep;
import org.gradle.api.internal.artifacts.transform.TransformChain;
import org.gradle.api.internal.artifacts.transform.TransformStep;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.TransformedArtifactSet;
import org.gradle.api.internal.artifacts.transform.TransformingAsyncArtifactListener;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.VariantIdentifier;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ValueCalculator;

public abstract class AbstractTransformedArtifactSet
implements TransformedArtifactSet,
FileCollectionInternal.Source {
    private final CalculatedValueContainer<ImmutableList<ResolvedArtifactSet.Artifacts>, CalculateArtifacts> result;

    public AbstractTransformedArtifactSet(ComponentIdentifier componentIdentifier, VariantIdentifier sourceVariantId, ResolvedArtifactSet delegate, ImmutableAttributes targetVariantAttributes, ImmutableCapabilities capabilities, TransformChain transformChain, TransformUpstreamDependenciesResolver dependenciesResolver, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        ImmutableList.Builder builder = ImmutableList.builder();
        transformChain.visitTransformSteps((Action<? super TransformStep>)((Action)step -> builder.add((Object)new BoundTransformStep((TransformStep)step, dependenciesResolver.dependenciesFor(componentIdentifier, (TransformStep)step)))));
        ImmutableList steps = builder.build();
        this.result = calculatedValueContainerFactory.create(Describables.of((Object)componentIdentifier), (ValueCalculator)new CalculateArtifacts(componentIdentifier, sourceVariantId, delegate, targetVariantAttributes, capabilities, (ImmutableList<BoundTransformStep>)steps));
    }

    public AbstractTransformedArtifactSet(CalculatedValueContainer<ImmutableList<ResolvedArtifactSet.Artifacts>, CalculateArtifacts> result) {
        this.result = result;
    }

    public CalculatedValueContainer<ImmutableList<ResolvedArtifactSet.Artifacts>, CalculateArtifacts> getResult() {
        return this.result;
    }

    @Override
    public void visit(ResolvedArtifactSet.Visitor visitor) {
        FileCollectionStructureVisitor.VisitType visitType = visitor.prepareForVisit(this);
        if (visitType == FileCollectionStructureVisitor.VisitType.NoContents) {
            visitor.visitArtifacts(new EndCollection(this));
            return;
        }
        this.result.finalizeIfNotAlready();
        for (ResolvedArtifactSet.Artifacts artifacts : (ImmutableList)this.result.get()) {
            artifacts.prepareForVisitingIfNotAlready();
            visitor.visitArtifacts(artifacts);
        }
        visitor.visitArtifacts(new EndCollection(this));
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        this.result.visitDependencies(context);
    }

    @Override
    public void visitTransformSources(ResolvedArtifactSet.TransformSourceVisitor visitor) {
        throw new IllegalStateException();
    }

    @Override
    public void visitExternalArtifacts(Action<ResolvableArtifact> visitor) {
        throw new IllegalStateException();
    }

    public static class CalculateArtifacts
    implements ValueCalculator<ImmutableList<ResolvedArtifactSet.Artifacts>> {
        private final ComponentIdentifier ownerId;
        private final VariantIdentifier sourceVariantId;
        private final ResolvedArtifactSet delegate;
        private final ImmutableList<BoundTransformStep> steps;
        private final ImmutableAttributes targetVariantAttributes;
        private final ImmutableCapabilities capabilities;

        public CalculateArtifacts(ComponentIdentifier ownerId, VariantIdentifier sourceVariantId, ResolvedArtifactSet delegate, ImmutableAttributes targetVariantAttributes, ImmutableCapabilities capabilities, ImmutableList<BoundTransformStep> steps) {
            this.ownerId = ownerId;
            this.sourceVariantId = sourceVariantId;
            this.delegate = delegate;
            this.steps = steps;
            this.targetVariantAttributes = targetVariantAttributes;
            this.capabilities = capabilities;
        }

        public ComponentIdentifier getOwnerId() {
            return this.ownerId;
        }

        public VariantIdentifier getSourceVariantId() {
            return this.sourceVariantId;
        }

        public ResolvedArtifactSet getDelegate() {
            return this.delegate;
        }

        public ImmutableList<BoundTransformStep> getSteps() {
            return this.steps;
        }

        public ImmutableAttributes getTargetVariantAttributes() {
            return this.targetVariantAttributes;
        }

        public ImmutableCapabilities getCapabilities() {
            return this.capabilities;
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            for (BoundTransformStep step : this.steps) {
                context.add((Object)step.getUpstreamDependencies());
            }
        }

        public ImmutableList<ResolvedArtifactSet.Artifacts> calculateValue(NodeExecutionContext context) {
            for (BoundTransformStep step : this.steps) {
                step.getTransformStep().isolateParametersIfNotAlready();
                step.getUpstreamDependencies().finalizeIfNotAlready();
            }
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)1);
            this.delegate.visit(new TransformingAsyncArtifactListener((List<BoundTransformStep>)this.steps, this.targetVariantAttributes, this.capabilities, (ImmutableList.Builder<ResolvedArtifactSet.Artifacts>)builder));
            return builder.build();
        }
    }
}

