##
## This file is part of the libsigrokdecode project.
##
## Copyright (C) 2012 Uwe Hermann <uwe@hermann-uwe.de>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, see <http://www.gnu.org/licenses/>.
##

# Device code addresses:
# 0x00: vendor code, 0x01: part family + flash size, 0x02: part number

# Vendor code
vendor_code = {
    0x1E: 'Atmel',
    0x00: 'Device locked',
}

# (Part family + flash size, part number)
part = {
    (0x90, 0x01): 'AT90S1200',
    (0x90, 0x05): 'ATtiny12',
    (0x90, 0x06): 'ATtiny15',
    (0x90, 0x07): 'ATtiny13(A)',
    (0x91, 0x01): 'AT90S2313',
    (0x91, 0x02): 'AT90S2323',
    (0x91, 0x03): 'AT90S2343',
    (0x91, 0x05): 'AT90S2333',
    (0x91, 0x06): 'ATtiny22',
    (0x91, 0x07): 'ATtiny28',
    (0x91, 0x08): 'ATtiny25',
    (0x91, 0x09): 'ATtiny26',
    (0x91, 0x0A): 'ATtiny2313(A)',
    (0x91, 0x0B): 'ATtiny24(A)',
    (0x91, 0x0C): 'ATtiny261(A)',
    (0x92, 0x01): 'AT90S4414',
    (0x92, 0x02): 'AT90S4434',
    (0x92, 0x03): 'AT90S4433',
    (0x92, 0x05): 'ATmega48(A)',
    (0x92, 0x06): 'ATtiny45',
    (0x92, 0x07): 'ATtiny44(A)',
    (0x92, 0x08): 'ATtiny461(A)',
    (0x92, 0x09): 'ATtiny48',
    (0x92, 0x0A): 'ATmega48P(A)',
    (0x92, 0x0C): 'ATtiny43U',
    (0x92, 0x0D): 'ATtiny4313',
    (0x92, 0x10): 'ATmega48PB',
    (0x92, 0x15): 'ATtiny441',
    (0x93, 0x01): 'AT90S8515',
    (0x93, 0x03): 'AT90S8535',
    (0x93, 0x06): 'ATmega8515',
    (0x93, 0x07): 'ATmega8(A)',
    (0x93, 0x08): 'ATmega8535',
    (0x93, 0x0A): 'ATmega88(A)',
    (0x93, 0x0B): 'ATtiny85',
    (0x93, 0x0C): 'ATtiny84(A)',
    (0x93, 0x0D): 'ATtiny861(A)',
    (0x93, 0x0F): 'ATmega88P(A)',
    (0x93, 0x10): 'ATmega8HVA',
    (0x93, 0x11): 'ATtiny88',
    (0x93, 0x14): 'ATtiny828(R)',
    (0x93, 0x15): 'ATtiny841',
    (0x93, 0x16): 'ATmega88PB',
    (0x93, 0x81): 'AT90PWM(2)(3)',
    (0x93, 0x82): 'AT90USB82',
    (0x93, 0x83): 'AT90PWM(1)(2B)(3B)',
    (0x93, 0x87): 'ATtiny87',
    (0x93, 0x88): 'AT90PWM81',
    (0x93, 0x89): 'ATmega8U2',
    (0x94, 0x01): 'ATmega161',
    (0x94, 0x02): 'ATmega163',
    (0x94, 0x03): 'ATmega16(A)',
    (0x94, 0x04): 'ATmega162',
    (0x94, 0x05): 'ATmega169(P)(PA)',
    (0x94, 0x06): 'ATmega168(A)',
    (0x94, 0x07): 'ATmega165(P)(PA)',
    (0x94, 0x0A): 'ATmega164P(A)',
    (0x94, 0x0B): 'ATmega168P(A)',
    (0x94, 0x0C): 'ATmega16HVA',
    (0x94, 0x0D): 'ATmega16HVB(rev. B)',
    (0x94, 0x0F): 'ATmega164A',
    (0x94, 0x10): 'ATmega165A',
    (0x94, 0x11): 'ATmega169A',
    (0x94, 0x12): 'ATtiny1634(R)',
    (0x94, 0x15): 'ATmega168PB',
    (0x94, 0x82): 'AT90USB162',
    (0x94, 0x83): 'AT90PWM(216)(316)',
    (0x94, 0x84): 'ATmega16M1',
    (0x94, 0x87): 'ATtiny167',
    (0x94, 0x88): 'ATmega16U4',
    (0x94, 0x89): 'ATmega16U2',
    (0x94, 0x8B): 'AT90PWM161',
    (0x95, 0x01): 'ATmega323',
    (0x95, 0x02): 'ATmega32(A)',
    (0x95, 0x03): 'ATmega329(A)',
    (0x95, 0x04): 'ATmega3290(A)',
    (0x95, 0x05): 'ATmega325(A)',
    (0x95, 0x06): 'ATmega3250(A)',
    (0x95, 0x08): 'ATmega324P',
    (0x95, 0x0B): 'ATmega329P(A)',
    (0x95, 0x0C): 'ATmega3290P(A)',
    (0x95, 0x0D): 'ATmega325P(A)',
    (0x95, 0x0E): 'ATmega3250P(A)',
    (0x95, 0x0F): 'ATmega328P',
    (0x95, 0x10): 'ATmega32HVB(rev. B)',
    (0x95, 0x11): 'ATmega324PA',
    (0x95, 0x13): 'ATmega32HVE2',
    (0x95, 0x14): 'ATmega328',
    (0x95, 0x15): 'ATmega324A',
    (0x95, 0x16): 'ATmega328PB',
    (0x95, 0x17): 'ATmega324PB',
    (0x95, 0x81): 'AT90CAN32',
    (0x95, 0x84): 'ATmega32M1',
    (0x95, 0x86): 'ATmega32C1',
    (0x95, 0x87): 'ATmega32U4',
    (0x95, 0x8A): 'ATmega32U2',
    (0x96, 0x02): 'ATmega64(A)',
    (0x96, 0x03): 'ATmega649(A)',
    (0x96, 0x04): 'ATmega6490',
    (0x96, 0x05): 'ATmega645(A)',
    (0x96, 0x06): 'ATmega6450(A)',
    (0x96, 0x08): 'ATmega640',
    (0x96, 0x09): 'ATmega644(A)',
    (0x96, 0x0A): 'ATmega644P(A)',
    (0x96, 0x0B): 'ATmega649P',
    (0x96, 0x0C): 'ATmega6490P',
    (0x96, 0x0D): 'ATmega645P',
    (0x96, 0x0E): 'ATmega6450P',
    (0x96, 0x10): 'ATmega64HVE2',
    (0x96, 0x81): 'AT90CAN64',
    (0x96, 0x82): 'AT90USB(646)(647)',
    (0x96, 0x84): 'ATmega64M1',
    (0x96, 0x86): 'ATmega64C1',
    (0x97, 0x01): 'ATmega103',
    (0x97, 0x02): 'ATmega128(A)',
    (0x97, 0x03): 'ATmega1280',
    (0x97, 0x04): 'ATmega1281',
    (0x97, 0x05): 'ATmega1284P',
    (0x97, 0x06): 'ATmega1284',
    (0x97, 0x81): 'AT90CAN128',
    (0x97, 0x82): 'AT90USB(1286)(1287)',
    (0x98, 0x01): 'ATmega2560',
    (0x98, 0x02): 'ATmega2561',
    (0xA6, 0x02): 'ATmega64RFR2',
    (0xA6, 0x03): 'ATmega644RFR2',
    (0xA7, 0x01): 'ATmega128RFA1',
    (0xA7, 0x02): 'ATmega128RFR2',
    (0xA7, 0x03): 'ATmega1284RFR2',
    (0xA8, 0x02): 'ATmega256RFR2',
    (0xA8, 0x03): 'ATmega2564RFR2',
    (0xFF, 0xFF): 'Device code erased, or target missing',
    (0x01, 0x02): 'Device locked',
}
